;;************************************************************************
;; graphelp.lsp 
;; contains help methods for the welcome message, the listener,
;; for spreadplots, printing, and reports, and for the basic set of plots
;; copyright (c) 1991-98 by Forrest W. Young
;;************************************************************************


(defun print-output () (plot-help-window (strcat "Help: Printing"))

(paste-plot-help (format nil "You can print ViSta results --- but not with ViSta. Instead, you use ViSta to save a copy of your results, and then you use another program to print them. Here's how you do it:~2%")) 

#-macintosh
(paste-plot-help (format nil "PRINTING ALL WINDOWS EXCEPT THE LISTENER:~%"))

#+macintosh (paste-plot-help (format nil "PRINTING ALL WINDOWS EXCEPT THE LISTENER, REPORT AND SUMMARY WINDOWS~%")) 

(paste-plot-help (format nil "1) Open and select the window with the information you wish to print.~%2) Use the EDIT menu's COPY item to copy the contents of the window to the clipboard.~%3) Use a word processing or graphics program to read the clipboard and then print the window.~2%")) 

#+macintosh(paste-plot-help (format nil "PRINTING REPORTS AND SUMMARIES:~%"))
#+macintosh(paste-plot-help (format nil "1) Open the window with the information you wish to print.~%2) Use the FILE menu's SAVE EDIT item to save the contents of the window to a file.~%3) Use SIMPLETEXT to print the information, using the MONACO 9-point font.~2%")) 

(paste-plot-help (format nil "PRINTING THE LISTENER:~%To print the information in the Listener, you must specify that you wish to record the information to a file, BEFORE the information is generated. This is done by using the Command Menu's RECORD LISTENER item. This item is a toggle which turns recording on and off. All information that appears in the window while the item is checkmarked (e.g., AFTER you use the item the first time and before you use it again) will be recorded in the file you specify in the file dialog. The file can then be printed with ")) 

#+macintosh(paste-plot-help (format nil "SIMPLETEXT, using the MONACO 9-point font."))

#-macintosh(paste-plot-help (format nil "a text or word processor.")) 
(show-plot-help))


(defmeth graph-window-proto :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
  (paste-plot-help (format nil "No help is available for this window."))
  (show-plot-help))

(defun listener-help ()
  (plot-help-window (strcat "Help: Listener Window"))
(paste-plot-help (format nil "The Listener Window displays messages about ViSta's operation and provides a place for typing statements in the underlying Lisp language, and in ViSta's ViVa language.~2%"))
  (paste-plot-help (format nil "There are two Listener Windows: The DeskTop Listener, which is in the main desktop window, and the XLisp-Stat Listener, which is in the XLisp-Stat window. You need to use the WINDOW menu's XLISP-STAT WINDOW item to see the XLispStat window. Only one of these is active at a time. Both work identically.~2%"))
(paste-plot-help (format nil "Several items of the WINDOW menu control aspects of the DeskTop Listener Window. The MAXIMIZE LISTENER menu item lets you maximize its size. The RESTORE LAYOUT item changes the desktop back to the basic layout. The DESKTOP LAYOUT item lets you change the number of lines shown in the DeskTop Listener.~2%"))
  (paste-plot-help (format nil "To save the information written to either Listener, use the OPTIONS Menu's RECORD LISTENER item. This item is a toggle which turns recording on and off. All information that appears in the window while the item is checkmarked (e.g., AFTER you use the item the first time and before you use it again) will be recorded in the file you specify in the file dialog.~2%"))
  (paste-plot-help (format nil "For more information about using the Listener for programming, see Luke Tierney's book on Lisp-Stat."))
  (show-plot-help))

(defmeth histogram-proto :plot-help (&key (flush t)) 
  (let ((overlay (first (send self :slot-value (quote overlays))))
        (w (plot-help-window 
            (strcat "Help for " (send self :title)) :flush flush))) 
    (paste-plot-help (format nil 
"The Histogram is designed to show you the shape of a variable's distribution. It does this by breaking the range of the variable's values into equal-sized intervals called BINS. It then displays the number of observations that fall into the interval (are in the BIN) as a bar whose height is proportional to the frequency in the interval. The higher the bar, the greater the frequency in the bin.~2%") w)
    (when (send overlay :density)
          (paste-plot-help
           (format nil
                   "The CURVES button can be used to add or remove several different distribution curves, including the normal distribution and several curves called \"kernel density distribution curves\". The kernel density distribution curves provide several alternate ways of approximating the shape of the population distribution. If the kernel density curves roughly approximate the normal distribution curve, then the variable's distribution approximates normality.~2%")))
    (when (send overlay :normal)
          (paste-plot-help 
           (format nil 
                   "The NORMAL button can be used to add or remove a normal distribution with the variable's mean and variance. If the histogram roughly approximates the normal distribution, then the variable's distribution approximates normality.~2%")))
(paste-plot-help (format nil 
"Unfortunately, the Histogram is notorious for presenting an impression of the shape of the variable's distribution that is very dependent on the number of bins choosen. Changing the number of bins may radically change the apparent shape of the distribution. Even more unfortunately, there is no entirely satisfactory way to solve this problem.~2%") w)
    (when (send overlay :bins)
          (paste-plot-help 
           (format nil
                   "For this reason, the BINS button at the top of the graph allows you to dynamically change the number of bins and watch the graph change in an animated way. You should always you this button to get a better impression of the distribution's shape, and to choose a good number of bins that adequately portrays the shape.~2%") w))
(when (send overlay :new-x)
(paste-plot-help  (format nil "When you click on the NEW X button at the top of the graph you will be presented with a list of variables to display. Clicking on a variable will change the plot to display that variable's Histogram.") w))
(show-plot-help)
    ))

(defmeth scatterplot-proto :plot-help (&key (flush t))
  (let ((overlay (first (send self :slot-value (quote overlays))))
        (w (plot-help-window (strcat "Help for " (send self :title))
                              :flush flush)))
    (paste-plot-help (format nil 
"The scatterplot is designed to display the relationship between two variables. The variables are represented by the X-axis and Y-axis.  The observed values on the two varibles are represented by points in the scatterplot. Each point  represents the values for (usually) one observation on two variables. The value can be approximately determined by seeing what value the point is above on the X-axis, and to the right of on the Y-axis.~2%") w)
(paste-plot-help (format nil 
"Two normally distributed variables will have a scatterplot which has the greatest density in the middle, is roughly eliptical in shape, and has no obvious outliers.~2%") w)
(when (send overlay :new-x)
(paste-plot-help  (format nil "When you click on the NEW X or NEW Y button at the top of the graph you will be presented with a list of variables. Clicking on a variable will change the plot to display a scatterplot of the new variables.") w))
(show-plot-help)
))

(defmeth spin-proto :plot-help (&key (flush t))
  (let ((w (plot-help-window (strcat "Help for " (send self :title))
                              :flush flush)))
    (paste-plot-help (format nil 
"The Spin plot presents a three-dimensional scatterplot which you can spin to observe the distribution of your data in three dimensions.~2%") w)
#|(paste-plot-help (format nil 
"The PITCH, ROLL, YAW and SPEED buttons at the bottom of the window control spinning (PITCH is up and down, ROLL is clockwise and counterclockwise, and YAW is left and right). ~2%") w)|#
(paste-plot-help (format nil 
"The Up/Dn, C/CC, and L/R buttons at the bottom of the window control spinning direction(the button names mean Up/Down, Clockwise/Counterclockwise and Left/Right). Click on a button to change direction. The SPEED buttons control the speed of spinning. Hold down a button to gradually increase or decrease the speed.~2%") w)
(paste-plot-help (format nil
"The SPIN button starts and stops rotation. You can also spin the space by using the HAND ROTATE tool (whose cursor is a hand) and dragging your cursor around the space. If your cursor is not a hand, you can get this tool by clicking on the MOUSE button at the top of the window. ") w)
(paste-plot-help (format nil "Finally, you can spin the space by holding down the shift key while you click on the rotate buttons, or while you use the HAND ROTATE tool: The spinning will continue by itself until you click on the SPIN button.~2%") w)
(paste-plot-help (format nil
"The HOME button returns the space to its original orientation and stops rotation.  The ROCK button reverses the direction of rotation: Repeatedly clicking on this button rocks the space back and forth, giving you a better view of the detailed location of points in the space. The CLIP button clips off garbage that sometimes appears at the edges of the window. Holding down a ZOOM button will gradually zoom the space in or out.~2%") w)
(when (send self :depth-cuing)
      (paste-plot-help (format nil
"Notice that the points in the space change in size as the space spins. This is to show whether they are close to you (larger) or far away (smaller).~2%") w))
(paste-plot-help (format nil
"At the top of the window are buttons that give you this help message, turn color on and off, and allow you to change the mouse-mode."))
(mapcar 
 #'(lambda (i)          
     (let ((overlay 
            (select (send self :slot-value 'overlays) i)))
       (when (send overlay :has-slot 'box)
             (when (send overlay :box)
                   (paste-plot-help  (format nil 
"In addition, the BOX button allows you to add or remove a three-dimensional box that encompasses the data points."))))))
 (iseq (length (send self :slot-value 'overlays))))
(mapcar #'(lambda (i)
               (let ((overlay (select (send self :slot-value 'overlays) i)))
                 (when (send overlay :has-slot 'new-x)
                       (when (send overlay :new-x)
                             (paste-plot-help  (format nil 
"The X, Y and Z buttons allow you to change which variable is shown on the X, Y, or Z axis."))))))
           (iseq (length (send self :slot-value 'overlays))))
    (show-plot-help))
  )

(defmeth scatmat-proto :plot-help (&key (flush t))
  (let ((overlay (first (send self :slot-value (quote overlays))))
        (w (plot-help-window (strcat "Help for " (send self :title))
                              :flush flush)))
    (paste-plot-help (format nil 
"The scatterplot matrix is designed to display the relationship between all pairs of several variables. The plot matrix consists of plotcells containing little scatterplots formed from a pair of variables. The variables are represented by the X-axis and Y-axis of each plotcell.  The observed values on the two varibles are represented by points in the little scatterplot. Each point  represents the values for (usually) one observation on two variables.~2%") w)
(paste-plot-help (format nil 
"Normally distributed variables will have scatterplots which have the greatest density in the middle, are roughly eliptical in shape, and have no obvious outliers. ~2%") w)
(paste-plot-help  (format nil "The scatterplot matrix can be used as a control panel for selecting variables, pairs of variables and triples of variables. When you click on a plotcell, that pair of variables is selected. When you click on a diagonal cell, a single variable is selected. Shift-clicking will select more variables.~2%") w)
(paste-plot-help  (format nil "When you use the scatterplot matrix to select one, two or three variables, various changes will appear in other plots. The specific changes depend on the nature of the SpreadPlot."))
(show-plot-help)
))


(defmeth NAME-LIST-PROTO :plot-help (&key (flush t)) 
  (let* ((title (send self :title))
         (obsvar))
    (plot-help-window (strcat "Help: " title)  :flush flush)
    (cond 
      ((not (or (equal title "Vars") (equal title "Var") 
                (equal title "Variables")
                (equal title "Obs") (equal title "Observations")))
       (paste-plot-help (format nil "The ~s window displays lists of names with which you can interact. In many situations you can select items in this window and see that corresponding items in other windows are also selected. You select items in this window by clicking on an item, by shift-clicking on several items, or by dragging your cursor over the items." title)))

      (t 
       (setf obs (or (equal title "Obs") (equal title "Observations")))
       (paste-plot-help 
        (format nil "The ~s window lists ~a. "
               title (if obs "observation labels" "names of variables")))
       (paste-plot-help 
        (format nil "You use this window, and the associated ~s window, to create a subset of \"active\" observations and variables. Only this subset will be used in any analyses you have ViSta do with this data object.~2%You make an item \"active\" by selecting it in the window. Items are selected by clicking on  them, or by shift-clicking or dragging your cursor over them."
                (if obs "Vars" "Obs")))
       (paste-plot-help 
        (format nil "~2%NOTE: \"Active\" variables and observations are those whose names appear in the windows. If any of these names are highlighted, then the \"active\" variables and observations are only those that are highlighted."))
       (paste-plot-help
        (format nil "~2%The window's ~s menu helps you form selections. It has items to remove names from the window, to focus only on those that are selected, to show all of the names or to cancel a selection." (if obs "OBS" "VAR")))
       (paste-plot-help 
        (format nil "~2%Note that you can use the DATA menu's CREATE DATA menu item to create a new data object which contains only those observations and variables that you selected in the OBS and VARS windows."))
       ))
    (show-plot-help)))

(defmeth graph-window-proto :spreadplot-help (&key (flush t))
  (plot-help-window (strcat "SpreadPlot Help") :flush flush)
  (paste-plot-help (format nil 
"A SpreadPlot is a group of plots. Usually these windows are linked together and interact with each other. When you make a change in one of the plots, the linkages cause changes to appear in other plots. The details of the linkages determine which plots change, and how they change.~2%"))
(paste-plot-help (format nil 
"Generally, the plots are linked through corresponding observations and/or variables: For example, when you change the color of a point in one plot, the  color of corresponding points in other plots may change as well.~2%"))
  (paste-plot-help (format nil 
"Sometimes the plots are linked through equations: When you change the position of a point in one plot, then for a particular model, this may imply that some of the parameter estimates have been changed. These new parameter estimates are entered into the model and changes in the model are shown in other plotss.~2%"))
  (paste-plot-help (format nil
"There are numerous SpreadPlots in ViSta. Each SpreadPlot has additional help that is taylored to the specific way in which it works. When you have a SpreadPlot showing, use the help menu to get help about that particular SpreadPlot."))
  (show-display-window *help-window* :fit t))

(defun options-and-window-menu (&optional admin)
  (options-menu admin))

(defun options-message (&optional admin)
  (options-menu admin))

(defun options-message (&optional admin)
  (options-menu admin))

#|
(defun options-menu (&optional admin)
  (let* ((w (desktop-help-window)))
    (send w :title "Help: Options Menu")
    (options-body w admin)
    ;(show-display-window w)
    w))
|#

(defun options-menu-help-text (&optional w admin)
  (list
    (format nil "HELP FOR THE OPTIONS MENU~2%The OPTIONS menu changes the way that ViSta works. ")
  (if *change-profiles*
      (format nil " The changes you make are saved and will be in effect when you use ViSta again. Details are given in this help message.")
      (format nil "  The changes you make remain in effect for the duration of the session, but will not be in effect the next time you use ViSta. Details are given in this help message."))
  (format nil "~2%DESKTOP LAYOUT:~%Use this to change the relative proportions of the various window-panes of the desktop, and to remove or add title bars to the window-panes.")
  (format nil "~2%DESKTOP COLORS:~%Changes the colors of windows, of tool and button bars,  and of icons and graph elements. You can set the maximum number of colors to correspond with your hardware's capabilities.")
  (format nil "~2%WORKMAP ICONS:~%Changes appearance of the icons that appear on the workmap.")
  (format nil "~2%FLOATING WORKBAR:~%Displays a floating workbar of menus and tools.")
  (format nil "~2%TOOLBAR BUTTONS:~%You can change the function (and number) of the buttons on the toolbar at the top of the workmap.")
  (when *change-profiles*
        (format nil "~2%PREFERENCES: ~%With the PREFERENCES item you can change the way that ViSta runs, including:~%> whether starting and quitting ViSta uses animation;~%> whether spinning plots are initially animated;~%> whether model reports and visualizations automatically appear;~%> and whether the data and model menus include items for each data and model object.")
        (format nil "~2%CHANGE FONT: ~%Initially, fonts and font sizes are set so that they look right with ViSta. You can use this item to change to other fonts or sizes, however, proportional width fonts will never look right, and some fixed width fonts also do not look right."))
  (when *change-excess*
        (format nil "~2%RUN EXCEL~% This item runs Excel, adding a VISTA menu to Excel. The menu has items which can be configured by the experienced ViSta user. See the help item for these features."))
#|
  (when *enable-screen-saver-feature* 
        (format nil "~2%SCREEN SAVER:~%Allows you to turn the screen saver on and off and to set the delay time and size of the screen saver window."))
|#
  (format nil "~2%SHOW CLOCK:~%Allows you to turn the morphing vista logo clock on and off. When the clock appears ViSta disappears, and can be made to reappear when the clock window is clicked.")
  (format nil "~2%RECORD LISTENER:~%Provides a way of recording the information that is written to the listener. This provides a partial, but not complete, mechanism for journaling your work.")
  #+macintosh(format nil "~2%REPEAT COMMAND: ~%This item repeates the previous command typed into the listener. It does not repeat the previous action unless it was typed into the listener.")
  (format nil "~2%REFRESH SYSTEM:~%Provides a way of refreshing the system after errors so that too many errors will not accumulate, causing \"Stack Overflow\" problems. The number of error levels (roughly the same as the number of errors since the system was refreshed) is indicated by a number in front of the Listener Window's prompt. Thus 2> indicates, roughly, two errors since refreshing. It is safest to use this item whenever the Listener window's prompt has a number in front of it.")))

  
(defun window-menu-help-text (&optional admin)
  (list
  (format nil "HELP FOR THE WINDOW MENU~2%The WINDOW menu lets you display ViSta's windows and lets you configure ViSta's desktop window. ")
  (if *change-profiles*
      (format nil " The changes you make are saved and will be in effect when you use ViSta again. Details are given in this help message.")
      (format nil "  The changes you make remain in effect for the duration of the session, but will not be in effect the next time you use ViSta. Details are given in this help message."))
  (format nil "~2%DESKTOP WINDOW~%XLISPSTAT WINDOW~%SPREADPLOT WINDOW~%REPORT WINDOW~%These items display the specified window")
  (format nil "~2%MAXIMIZE WORKMAP~%MAXIMIZE DATASHEET~%MAXIMIZE LISTENER~%RESTORE LAYOUT~%The MAXIMIZE items effect the window panes of the desktop window by maximizing the specified pane to occupy the entire height of the DeskTop window. RESTORE LAYOUT item restores maximized panes to their size prior to maximization.")
  (format nil "~2%HIDE/SHOW SELECTOR~%HIDE/SHOW LISTENER~%These items hide or show their respective window panes.")
  (format nil "~2%MAXIMIZE DESKTOP~%RESTORE DESKTOP~%REFRESH DESKTOP~%These items effect the desktop window. REFRESH DESKTOP item refreshes the window.  This item is useful if the contents of the window do not appear to be drawn correctly.")
  ))